/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.device;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.RockGenMapping;
import cofh.thermal.lib.util.managers.AbstractManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class RockGenManager
extends AbstractManager {
    private static final RockGenManager INSTANCE = new RockGenManager();
    protected static final RockGenRecipe DEFAULT_RECIPE = new RockGenRecipe(RockGenManager.instance().getDefaultEnergy(), Blocks.f_50016_, Blocks.f_50016_, ItemStack.f_41583_);
    protected Map<Block, Map<Block, RockGenRecipe>> recipeMap = new IdentityHashMap<Block, Map<Block, RockGenRecipe>>();
    protected Map<Block, RockGenRecipe> defaultRecipeMap = new IdentityHashMap<Block, RockGenRecipe>();

    protected RockGenManager() {
        super(20);
    }

    public static RockGenManager instance() {
        return INSTANCE;
    }

    protected void clear() {
        this.recipeMap.clear();
        this.defaultRecipeMap.clear();
    }

    public RockGenRecipe getResult(Block below, Block[] adjacent) {
        Map<Block, RockGenRecipe> baseMap = this.recipeMap.get(below);
        if (baseMap != null) {
            for (Block adj : adjacent) {
                if (!baseMap.containsKey(adj)) continue;
                return baseMap.getOrDefault(adj, DEFAULT_RECIPE);
            }
        }
        baseMap = this.defaultRecipeMap;
        for (Block adj : adjacent) {
            if (!baseMap.containsKey(adj)) continue;
            return baseMap.getOrDefault(adj, DEFAULT_RECIPE);
        }
        return DEFAULT_RECIPE;
    }

    public boolean addMapping(int time, Block below, Block adjacent, ItemStack stack) {
        if (adjacent == Blocks.f_50016_ || stack.m_41619_()) {
            return false;
        }
        if (below == Blocks.f_50016_) {
            this.defaultRecipeMap.put(adjacent, new RockGenRecipe(time, below, adjacent, stack));
            return true;
        }
        if (!this.recipeMap.containsKey(below)) {
            this.recipeMap.put(below, (Map<Block, RockGenRecipe>)new Object2ObjectOpenHashMap());
        }
        this.recipeMap.get(below).put(adjacent, new RockGenRecipe(time, below, adjacent, stack));
        return true;
    }

    public void addMapping(RockGenMapping mapping) {
        this.addMapping(mapping.getTime(), mapping.getBelow(), mapping.getAdjacent(), mapping.getResult());
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map mappings = recipeManager.m_44054_(TCoreRecipeTypes.MAPPING_ROCK_GEN);
        for (Map.Entry entry : mappings.entrySet()) {
            this.addMapping((RockGenMapping)((Object)entry.getValue()));
        }
    }

    public static class RockGenRecipe {
        protected final int time;
        protected final Block below;
        protected final Block adjacent;
        protected final ItemStack result;

        public RockGenRecipe(int time, Block below, Block adjacent, ItemStack result) {
            this.time = time;
            this.below = below;
            this.adjacent = adjacent;
            this.result = result;
        }

        public int getTime() {
            return this.time;
        }

        public Block getAdjacent() {
            return this.adjacent;
        }

        public Block getBelow() {
            return this.below;
        }

        public ItemStack getResult() {
            return this.result;
        }
    }
}

